#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <mem.h>
#include "graf.h"

byte *VGA=(byte *)0xA0000000L;        /* this points to video memory. */

void rellenaaux(int x,int y,char color1,char color2)
{
word off;

off=(y*320)+x;
if (VGA[off]==color1 || VGA[off]==color2 || x<0 || x>319 || y<0 || y>199)
 {
 return;
 }
else
 {
 VGA[off]=color1;
 rellenaaux(x+1,y,color1,color2);
 rellenaaux(x-1,y,color1,color2);
 rellenaaux(x,y+1,color1,color2);
 rellenaaux(x,y-1,color1,color2);
 return;
 }
}

void rellena(int x,int y,char color1,char color2)
{
word off;

off=(y*320)+x;
if (VGA[off]==color1 || VGA[off]==color2 || x<0 || x>319 || y<0 || y>199)
 {
 return;
 }
else
 {
 VGA[off]=color1;
 rellenaaux(x+1,y,color1,color2);
 rellenaaux(x-1,y,color1,color2);
 rellenaaux(x,y+1,color1,color2);
 rellenaaux(x,y-1,color1,color2);
 return;
 }
}

void rectangulo(int left,int top, int right, int bottom, char color)
{
  word top_offset,bottom_offset,i,temp;

  if (top>bottom)
  {
    temp=top;
    top=bottom;
    bottom=temp;
  }
  if (left>right)
  {
    temp=left;
    left=right;
    right=temp;
  }

  top_offset=(top<<8)+(top<<6);
  bottom_offset=(bottom<<8)+(bottom<<6);

  for(i=left;i<=right;i++)
  {
    VGA[top_offset+i]=color;
    VGA[bottom_offset+i]=color;
  }
  for(i=top_offset;i<=bottom_offset;i+=SCREEN_WIDTH)
  {
    VGA[left+i]=color;
    VGA[right+i]=color;
  }
}

/**************************************************************************
 *  rect_fill                                                             *
 *    Draws and fills a rectangle.                                        *
 **************************************************************************/

void rectangulolleno(int left,int top, int right, int bottom, char color)
{
  word top_offset,bottom_offset,i,temp,width;

  if (top>bottom)
  {
    temp=top;
    top=bottom;
    bottom=temp;
  }
  if (left>right)
  {
    temp=left;
    left=right;
    right=temp;
  }

  top_offset=(top<<8)+(top<<6)+left;
  bottom_offset=(bottom<<8)+(bottom<<6)+left;
  width=right-left+1;

  for(i=top_offset;i<=bottom_offset;i+=SCREEN_WIDTH)
  {
    memset(&VGA[i],color,width);
  }
}

void set_mode(byte mode)
{
  union REGS regs;

  regs.h.ah = SET_MODE;
  regs.h.al = mode;
  int86(VIDEO_INT, &regs, &regs);
}

/**************************************************************************
 *  load_bmp                                                              *
 *    Loads a bitmap file into memory.                                    *
 **************************************************************************/

void load_bmp(char *file,BITMAP *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)((b->width+1)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    b->palette[(int)(index*3+2)] = fgetc(fp) >> 2;
    b->palette[(int)(index*3+1)] = fgetc(fp) >> 2;
    b->palette[(int)(index*3+0)] = fgetc(fp) >> 2;
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    fgetc(fp);
    }
  fclose(fp);
}

void load_bmp3(char *file,BITMAP *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)((b->width+2)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    b->palette[(int)(index*3+2)] = fgetc(fp) >> 2;
    b->palette[(int)(index*3+1)] = fgetc(fp) >> 2;
    b->palette[(int)(index*3+0)] = fgetc(fp) >> 2;
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    fgetc(fp);
    fgetc(fp);
    }
  fclose(fp);
}

void load_bmp2(char *file,BITMAP *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)(b->width*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    b->palette[(int)(index*3+2)] = fgetc(fp) >> 2;
    b->palette[(int)(index*3+1)] = fgetc(fp) >> 2;
    b->palette[(int)(index*3+0)] = fgetc(fp) >> 2;
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    }
  fclose(fp);
}

void load_objeto4(char *file,OBJETO *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }
  if ((b->restaura = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    fgetc(fp);
    fgetc(fp);
    fgetc(fp);
    }
  fclose(fp);
}

void load_objeto2(char *file,OBJETO *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }
  if ((b->restaura = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    fgetc(fp);
    }
  fclose(fp);
}

void load_objeto3(char *file,OBJETO *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }
  if ((b->restaura = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    fgetc(fp);
    fgetc(fp);
    }
  fclose(fp);
}
void load_objeto1(char *file,OBJETO *b)
{
  FILE *fp;
  long index;
  int x,num_colors;

  /* open the file */
  if ((fp = fopen(file,"rb")) == NULL)
  {
    printf("Error opening file %s.\n",file);
    exit(1);
  }

  /* check to see if it is a valid bitmap file */
  if (fgetc(fp)!='B' || fgetc(fp)!='M')
  {
    fclose(fp);
    printf("%s is not a bitmap file.\n",file);
    exit(1);
  }

  /* read in the width and height of the image, and the
     number of colors used; ignore the rest */
  fskip(fp,16);
  fread(&b->width, sizeof(word), 1, fp);
  fskip(fp,2);
  fread(&b->height,sizeof(word), 1, fp);
  fskip(fp,22);
  fread(&num_colors,sizeof(word), 1, fp);
  fskip(fp,6);

  /* assume we are working with an 8-bit file */
  if (num_colors==0) num_colors=256;


  /* try to allocate memory */
  if ((b->data = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }
  if ((b->restaura = (byte *) malloc((word)((b->width+3)*b->height))) == NULL)
  {
    fclose(fp);
    printf("Error allocating memory for file %s.\n",file);
    exit(1);
  }

  /* read the palette information */
  for(index=0;index<num_colors;index++)
  {
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
    x=fgetc(fp);
  }

  /* read the bitmap */
  for(index=(b->height-1)*b->width;index>=0;index-=b->width)
    {
    for(x=0;x<b->width;x++)
      {
      b->data[(word)(index+x)]=(byte)fgetc(fp);
      }
    }
  fclose(fp);
}

void draw_bitmap(BITMAP *bmp,int x,int y)
{
  int j;
  word screen_offset = (y<<8)+(y<<6)+x;
  word bitmap_offset = 0;

  for(j=0;j<bmp->height;j++)
  {
    memcpy(&VGA[screen_offset],&bmp->data[bitmap_offset],bmp->width);

    bitmap_offset+=bmp->width;
    screen_offset+=SCREEN_WIDTH;
  }
}

void set_palette(byte *palette)
{
  int i;

  outp(PALETTE_INDEX,0);              /* tell the VGA that palette data
					 is coming. */
  for(i=0;i<256*3;i++)
    outp(PALETTE_DATA,palette[i]);    /* write the data */
}

void wait_for_retrace(void)
{
    while  ((inp(INPUT_STATUS) & VRETRACE)) {};
    while (!(inp(INPUT_STATUS) & VRETRACE)) {};
}

void limpiarpantalla(void)
{
memset(VGA,'\0',64000);
}

void muestra(int x,int y,OBJETO *objeto,COOR coor,byte *pantaux)
{
  int i,j;
  word screen_offset = (y<<8)+(y<<6);
  word bitmap_offset = 0;
  byte data;

  for(j=0;j<objeto->height;j++)
  {
    for(i=0;i<objeto->width;i++,bitmap_offset++)
    {
      if(x+i>=coor.x1 && x+i<coor.x2 && y+j>=coor.y1 && y+j<coor.y2)
      {
      data = objeto->data[bitmap_offset];
      if (data) pantaux[screen_offset+x+i] = data;
      }
    }
    screen_offset+=320;
  }
}

void oculta(int x,int y,OBJETO *objeto,byte *pantaux)
{
  int i,j;
  word screen_offset = (y<<8)+(y<<6);
  word bitmap_offset = 0;
  byte data;

  for(j=0;j<objeto->height;j++)
  {
    for(i=0;i<objeto->width;i++,bitmap_offset++)
    {
      if(x+i>=0 && x+i<260 && y+j>=0 && y+j<200)
      {
      pantaux[screen_offset+x+i] = objeto->restaura[bitmap_offset];
      }
    }
    screen_offset+=320;
  }
}

void salva(int x,int y,OBJETO *objeto,byte *pantaux)
{
  int i,j;
  word screen_offset = (y<<8)+(y<<6);
  word bitmap_offset = 0;
  byte data;

  for(j=0;j<objeto->height;j++)
  {
    for(i=0;i<objeto->width;i++,bitmap_offset++)
    {
    objeto->restaura[bitmap_offset] = pantaux[screen_offset+x+i];
    }
    screen_offset+=320;
  }
}

void recogepant(byte *pant)
{
memcpy(pant,VGA,320*200);
}

void ponpant(byte *pant)
{
memcpy(VGA,pant,320*200);
}

void vida(BITMAP *bmp,BITMAP *cal,int vida)
{
int j,aux;
word screen_offset;
word bitmap_offset = 0;

if(vida>96)
 {
 aux=144-vida;
 screen_offset=267;
 for(j=0;j<aux;j++)
 {
    memcpy(&VGA[screen_offset],&cal->data[bitmap_offset],cal->width);
    bitmap_offset+=cal->width;
    screen_offset+=SCREEN_WIDTH;
 }
 for(j=aux;j<48;j++)
 {
    memcpy(&VGA[screen_offset],&bmp->data[bitmap_offset],bmp->width);
    bitmap_offset+=bmp->width;
    screen_offset+=SCREEN_WIDTH;
 }
 draw_bitmap(bmp,267,48);
 draw_bitmap(bmp,267,96);
 return;
 }
if(vida>48)
 {
 draw_bitmap(cal,267,0);
 screen_offset=15627;
 aux=96-vida;
 for(j=0;j<aux;j++)
 {
    memcpy(&VGA[screen_offset],&cal->data[bitmap_offset],cal->width);
    bitmap_offset+=cal->width;
    screen_offset+=SCREEN_WIDTH;
 }
 for(j=aux;j<48;j++)
 {
    memcpy(&VGA[screen_offset],&bmp->data[bitmap_offset],bmp->width);
    bitmap_offset+=bmp->width;
    screen_offset+=SCREEN_WIDTH;
 }
 draw_bitmap(bmp,267,96);
 return;
 }
draw_bitmap(cal,267,0);
draw_bitmap(cal,267,48);
aux=48-vida;
screen_offset=30987;
for(j=0;j<aux;j++)
{
   memcpy(&VGA[screen_offset],&cal->data[bitmap_offset],cal->width);
   bitmap_offset+=cal->width;
   screen_offset+=SCREEN_WIDTH;
}
for(j=aux;j<48;j++)
{
   memcpy(&VGA[screen_offset],&bmp->data[bitmap_offset],bmp->width);
   bitmap_offset+=bmp->width;
   screen_offset+=SCREEN_WIDTH;
}
return;
}

void puntos(int puntos)
{
rectangulolleno(270,200-puntos,295,200,200);
}
