#define VIDEO_INT           0x10      /* the BIOS video interrupt. */
#define SET_MODE            0x00      /* BIOS func to set the video mode. */
#define VGA_256_COLOR_MODE  0x13      /* use to set 256-color mode. */
#define TEXT_MODE           0x03      /* use to set 80x25 text mode. */

#define PALETTE_INDEX       0x03c8
#define PALETTE_DATA        0x03c9
#define INPUT_STATUS        0x03da
#define VRETRACE            0x08

#define SCREEN_WIDTH        320       /* width in pixels of mode 0x13 */
#define SCREEN_HEIGHT       200       /* height in pixels of mode 0x13 */
#define NUM_COLORS          256       /* number of colors in mode 0x13 */

/* macro to skip bytes in a file */
#define fskip(fp,n)   \
{                     \
   int i;             \
		      \
   for (i=0;i<n;i++)  \
      fgetc(fp);      \
}

typedef unsigned char  byte;
typedef unsigned short word;
typedef unsigned long  dword;


typedef struct tagBITMAP              /* the structure for a bitmap. */
{
  word width;
  word height;
  byte palette[256*3];
  byte *data;
} BITMAP;

typedef struct tagOBJETO
{
  word width;
  word height;
  byte *data;
  byte *restaura;
} OBJETO;

typedef struct tagCOOR
{
  int x1;
  int x2;
  int y1;
  int y2;
} COOR;

void rellena(int x,int y,char color1,char color2);
void rectangulo(int x1,int y1,int x2,int y2,char color);
void rectangulolleno(int x1,int y1,int x2,int y2,char color);
void set_mode(byte mode);
void load_bmp(char *file,BITMAP *b);
void load_bmp2(char *file,BITMAP *b);
void load_bmp3(char *file,BITMAP *b);
void load_objeto4(char *file,OBJETO *b);
void load_objeto3(char *file,OBJETO *b);
void load_objeto2(char *file,OBJETO *b);
void load_objeto1(char *file,OBJETO *b);
void draw_bitmap(BITMAP *bmp,int x,int y);
void set_palette(byte *palette);
void wait_for_retrace(void);
void limpiarpantalla(void);
void muestra(int x,int y,OBJETO *objeto,COOR coor,byte *pant);
void oculta(int x,int y,OBJETO *objeto,byte *pant);
void salva(int x,int y,OBJETO *objeto,byte *pant);
void recogepant(byte *pant);
void ponpant(byte *pant);
void vida(BITMAP *bmp,BITMAP *cal,int vida);
void puntos(int puntos);